/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.entity;

import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.rosebushes.alchemyexpanded.item.AEItems;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class YoYoProjectileEntity
extends ThrowableItemProjectile {
    private float realDamage;
    private int hitCheck = 0;
    private int stringLength;
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(YoYoProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public YoYoProjectileEntity(EntityType<? extends YoYoProjectileEntity> type, Level level) {
        super(type, level);
    }

    public YoYoProjectileEntity(EntityType<? extends YoYoProjectileEntity> type, LivingEntity livingEntityIn, Level level, float damage, int stringLength, int maxTick) {
        super(type, livingEntityIn, level);
        this.realDamage = damage;
        this.stringLength = stringLength;
        this.setLifespan(maxTick);
    }

    protected void onHit(HitResult result) {
        if (result.getType() == HitResult.Type.ENTITY) {
            if (!this.level().isClientSide) {
                Entity entity = ((EntityHitResult)result).getEntity();
                if (this.hitCheck > 2) {
                    if (entity instanceof UnderlingEntity) {
                        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.realDamage * 1.5f);
                    } else if (entity != this.getOwner()) {
                        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.realDamage);
                    } else {
                        this.discard();
                    }
                } else {
                    if (entity instanceof UnderlingEntity) {
                        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.realDamage * 1.5f);
                    } else if (entity != this.getOwner()) {
                        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.realDamage);
                    }
                    ++this.hitCheck;
                    this.realDamage *= 0.5f;
                }
            }
        } else if (result.getType() == HitResult.Type.BLOCK) {
            this.discard();
        }
    }

    public void tick() {
        this.level().addParticle((ParticleOptions)ParticleTypes.END_ROD, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
        Vec3 pos = this.position();
        this.xOld = pos.x;
        this.yOld = pos.y;
        this.zOld = pos.z;
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.2));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.005));
        }
        if (this.tickCount >= this.stringLength) {
            this.setDeltaMovement(this.getDeltaMovement().scale(0.0));
        }
        if (this.tickCount >= this.getLifespan()) {
            this.discard();
        }
        super.tick();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFESPAN, (Object)20);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.realDamage = compound.getFloat("weapon_damage");
        this.stringLength = compound.getInt("string_length");
        this.hitCheck = compound.getInt("hit_check");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putFloat("weapon_damage", this.realDamage);
        compound.putInt("string_length", this.stringLength);
        compound.putInt("hit_check", this.hitCheck);
    }

    protected Item getDefaultItem() {
        return (Item)AEItems.YOYO.get();
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int v) {
        this.entityData.set(LIFESPAN, (Object)v);
    }
}

