/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.event;

import com.rosebushes.alchemyexpanded.entity.CueballProjectileEntity;
import com.rosebushes.alchemyexpanded.entity.ProjectileEntity;
import com.rosebushes.alchemyexpanded.entity.TeleportProjectileEntity;
import com.rosebushes.alchemyexpanded.item.shield.AEShieldItem;
import com.rosebushes.alchemyexpanded.item.shield.DamagingShieldItem;
import com.rosebushes.alchemyexpanded.item.shield.FireShieldItem;
import com.rosebushes.alchemyexpanded.item.shield.PogoShieldItem;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingKnockBackEvent;

@EventBusSubscriber(modid="alchemyexpanded")
public class AEServerEventHandler {
    private static boolean hitByGun;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityDamagedEvent(LivingIncomingDamageEvent event) {
        DamageSource source = event.getEntity().getLastDamageSource();
        if (source != null && (source.getDirectEntity() instanceof ProjectileEntity || source.getDirectEntity() instanceof TeleportProjectileEntity || source.getDirectEntity() instanceof CueballProjectileEntity)) {
            hitByGun = true;
        }
    }

    public static boolean wasHitByGun() {
        return hitByGun;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityKnockbackEvent(LivingKnockBackEvent event) {
        if (AEServerEventHandler.wasHitByGun()) {
            event.setStrength(0.0f);
            hitByGun = false;
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingIncomingDamageEvent event) {
        float damage = event.getAmount();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            Entity sourceEntity = event.getSource().getDirectEntity();
            if (!player.getUseItem().isEmpty() && player.getUseItem().getItem() instanceof AEShieldItem && sourceEntity != null) {
                ItemStack shield = player.getUseItem();
                if (damage >= 3.0f && !shield.isEmpty() && sourceEntity instanceof LivingEntity) {
                    if (player.getUsedItemHand() == InteractionHand.MAIN_HAND) {
                        shield.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    } else {
                        shield.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.OFFHAND);
                    }
                }
                if (sourceEntity instanceof LivingEntity) {
                    LivingEntity livingAttacker = (LivingEntity)sourceEntity;
                    if (shield.getItem() instanceof FireShieldItem) {
                        livingAttacker.setRemainingFireTicks(5);
                    }
                    if (shield.getItem() instanceof DamagingShieldItem) {
                        livingAttacker.hurt(player.damageSources().playerAttack(player), damage / 10.0f);
                    }
                    if (shield.getItem() instanceof PogoShieldItem) {
                        livingAttacker.setDeltaMovement(livingAttacker.getLookAngle().reverse().scale(0.5));
                    }
                }
            }
        }
    }
}

