/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.armor;

import com.rosebushes.alchemyexpanded.item.armor.AEArmorItem;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class ItemMagnetArmorItem
extends AEArmorItem {
    private final int radius;

    public ItemMagnetArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, int radius) {
        super(material, type, properties);
        this.radius = radius;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (entity instanceof Player && ((player = (Player)entity).getItemBySlot(EquipmentSlot.HEAD).getItem() instanceof ItemMagnetArmorItem || player.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ItemMagnetArmorItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof ItemMagnetArmorItem || player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof ItemMagnetArmorItem)) {
            AABB bound = player.getBoundingBox();
            AABB newBound = bound.inflate((double)this.radius);
            List entities = level.getEntities((Entity)player, newBound);
            for (Entity i : entities) {
                if (!(i instanceof ItemEntity)) continue;
                ItemEntity item = (ItemEntity)i;
                if (player.getInventory().getSlotWithRemainingSpace(item.getItem()) == -1 && player.getInventory().getFreeSlot() == -1 || player.isCrouching() || level.isClientSide()) continue;
                item.setPos(player.getPosition(1.0f));
            }
        }
    }
}

