/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.armor;

import com.mraof.minestuck.util.MSParticleType;
import com.mraof.minestuck.util.MSSoundEvents;
import com.rosebushes.alchemyexpanded.client.model.armor.RocketBootsArmorModel;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RocketBootsArmorItem
extends ArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public RocketBootsArmorItem(Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof RocketBootsArmorItem && player.isShiftKeyDown()) {
                Vec3 look = player.getLookAngle();
                Vec3 movement = player.getDeltaMovement();
                player.level().playSound(player, player.blockPosition(), (SoundEvent)MSSoundEvents.ITEM_JETPACK_FLIGHT.get(), SoundSource.PLAYERS, 1.0f, player.getRandom().nextFloat() + 0.35f);
                player.level().addParticle((ParticleOptions)MSParticleType.EXHAUST.get(), player.getX(), player.getY(), player.getZ(), 0.0, 0.0, 0.0);
                player.level().addParticle((ParticleOptions)MSParticleType.EXHAUST.get(), player.getX() - movement.x / 2.0, player.getY() - movement.y / 2.0, player.getZ() - movement.z / 2.0, 0.0, 0.0, 0.0);
                player.setDeltaMovement(movement.add(look.x * 0.1 + (look.x * 1.5 - movement.x) * 0.2, look.y * 0.1 + (look.y * 1.5 - movement.y) * 0.2, look.z * 0.1 + (look.z * 1.5 - movement.z) * 0.2));
            }
            if (!player.level().isClientSide) {
                ItemStack feet;
                if ((player.getFallFlyingTicks() + 1) % 20 == 0) {
                    stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.CHEST);
                }
                if ((feet = player.getItemBySlot(EquipmentSlot.FEET)).getItem() instanceof RocketBootsArmorItem && player.isShiftKeyDown() && (player.getFallFlyingTicks() + 1) % 5 == 0) {
                    feet.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.FEET);
                }
            }
        }
        return true;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                if (this.renderer == null) {
                    this.renderer = new GeoArmorRenderer((GeoModel)new RocketBootsArmorModel());
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "Fly/Idle", 3, state -> {
            LivingEntity livingEntity;
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isFallFlying()) {
                return state.setAndContinue(DefaultAnimations.FLY);
            }
            return state.setAndContinue(DefaultAnimations.IDLE);
        })});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

