/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.enchantments;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;

public record SpareShotEnchantmentEffect(LevelBasedValue chance) implements EnchantmentValueEffect
{
    public static final MapCodec<SpareShotEnchantmentEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("chance").forGetter(SpareShotEnchantmentEffect::chance)).apply((Applicative)instance, SpareShotEnchantmentEffect::new));

    public float process(int level, RandomSource randomSource, float tries) {
        float c = this.chance.calculate(level);
        boolean yes = false;
        int t = 0;
        while ((float)t < tries) {
            if (randomSource.nextFloat() <= c) {
                yes = true;
            }
            ++t;
        }
        return (float)yes;
    }

    public MapCodec<? extends EnchantmentValueEffect> codec() {
        return CODEC;
    }
}

