/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon;

import com.rosebushes.alchemyexpanded.item.components.AEItemComponents;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;

public class GloveWeaponItem
extends Item {
    private final int meleeDamage;
    private final float attackSpeed;
    private final MobEffectInstance knockoutEffect;
    private final ItemAttributeModifiers modifiers;

    public GloveWeaponItem(Item.Properties properties, int atkDamage, float atkSpeed, Holder<MobEffect> effect) {
        super(properties);
        this.meleeDamage = atkDamage;
        this.attackSpeed = atkSpeed;
        this.knockoutEffect = new MobEffectInstance(effect, 80, 2);
        ItemAttributeModifiers tempModifiers = ItemAttributeModifiers.EMPTY;
        tempModifiers = tempModifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemyexpanded", (String)"glove_attack_modifier"), (double)this.meleeDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        this.modifiers = tempModifiers = tempModifiers.withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemyexpanded", (String)"glove_attack_speed_modifier"), (double)this.attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (this.getComboTimer(stack) >= 80) {
            this.setComboTimer(stack, 0);
            this.setHitCount(stack, 0);
        }
        if (this.getComboTimer(stack) > 0) {
            this.setComboTimer(stack, this.getComboTimer(stack) + 1);
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.getComboTimer(stack) < 80 && this.getComboTimer(stack) > 0) {
            if (this.getHitCount(stack) >= 5) {
                boolean playerDamage = attacker instanceof Player ? target.hurt(attacker.damageSources().playerAttack((Player)attacker), (float)this.meleeDamage * 2.0f) : target.hurt(attacker.damageSources().mobAttack(attacker), (float)this.meleeDamage * 1.5f);
                this.doKnockoutExtras(stack, target, attacker);
                if (playerDamage) {
                    Player player = (Player)attacker;
                    target.addEffect(new MobEffectInstance(this.knockoutEffect));
                    player.displayClientMessage((Component)Component.translatable((String)"message.alchemyexpanded.glove.combo_max"), true);
                    player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 1.0f, 0.8f);
                }
                this.setHitCount(stack, 0);
                this.setComboTimer(stack, 0);
            } else {
                this.setHitCount(stack, this.getHitCount(stack) + 1);
            }
        } else {
            this.setComboTimer(stack, 1);
            this.setHitCount(stack, this.getHitCount(stack) + 1);
        }
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    public void doKnockoutExtras(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.level().isClientSide) {
            target.level().explode((Entity)attacker, target.getX(), target.getY(), target.getZ(), 2.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.modifiers;
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    private void setHitCount(ItemStack stack, int amount) {
        stack.set(AEItemComponents.GLOVE_HIT_COUNT, (Object)amount);
    }

    private int getHitCount(ItemStack stack) {
        return (Integer)stack.getOrDefault(AEItemComponents.GLOVE_HIT_COUNT, (Object)0);
    }

    private void setComboTimer(ItemStack stack, int amount) {
        stack.set(AEItemComponents.GLOVE_COMBO_TIMER, (Object)amount);
    }

    private int getComboTimer(ItemStack stack) {
        return (Integer)stack.getOrDefault(AEItemComponents.GLOVE_COMBO_TIMER, (Object)0);
    }

    public int getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }
}

