/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon;

import com.mraof.minestuck.util.MSSoundEvents;
import com.rosebushes.alchemyexpanded.entity.AEEntities;
import com.rosebushes.alchemyexpanded.entity.YoYoProjectileEntity;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class YoYoWeaponItem
extends Item {
    protected final int damage;
    protected final int cooldown;
    protected final int stringLength;
    protected final Item yoyoProj;

    public YoYoWeaponItem(Item.Properties properties, int dmg, int cooldown, int stringLength, Item item) {
        super(properties);
        this.damage = dmg;
        this.cooldown = cooldown;
        this.stringLength = stringLength;
        this.yoyoProj = item;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        player.startUsingItem(usedHand);
        return InteractionResultHolder.success((Object)stack);
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack item, int remainingUseDuration) {
        if (remainingUseDuration <= 1 && livingEntity instanceof Player) {
            Player playerIn = (Player)livingEntity;
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)MSSoundEvents.ITEM_PROJECTILE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                this.yoYo(serverPlayer, level, 1.25f);
            }
            item.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public void releaseUsing(ItemStack item, Level level, LivingEntity livingEntity, int timeCharged) {
        float dmgMod;
        float f = dmgMod = timeCharged > this.cooldown ? 0.25f : 0.75f;
        if (timeCharged >= this.getUseDuration(item, livingEntity) - 5) {
            return;
        }
        if (timeCharged <= 1) {
            return;
        }
        if (timeCharged <= 8) {
            dmgMod = 2.0f;
        }
        if (livingEntity instanceof Player) {
            Player playerIn = (Player)livingEntity;
            if (dmgMod == 2.0f) {
                level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)MSSoundEvents.ITEM_MAGIC_CAST.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (level.isClientSide) {
                    playerIn.displayClientMessage((Component)Component.translatable((String)"message.alchemyexpanded.yoyo.crit"), true);
                }
            }
            level.playSound((Player)null, playerIn.getX(), playerIn.getY(), playerIn.getZ(), (SoundEvent)MSSoundEvents.ITEM_PROJECTILE_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
            if (playerIn instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)playerIn;
                this.yoYo(serverPlayer, level, dmgMod);
            }
            item.hurtAndBreak(1, (LivingEntity)playerIn, EquipmentSlot.MAINHAND);
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.cooldown * 2;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void yoYo(ServerPlayer playerIn, Level level, float damageMod) {
        YoYoProjectileEntity yoyo = new YoYoProjectileEntity(AEEntities.YOYO_PROJECTILE.get(), (LivingEntity)playerIn, level, (float)this.damage * damageMod, this.stringLength, 20);
        yoyo.setItem(new ItemStack((ItemLike)this.yoyoProj));
        yoyo.shootFromRotation((Entity)playerIn, playerIn.getXRot(), playerIn.getYRot(), 0.0f, 1.0f, 0.1f);
        yoyo.setNoGravity(true);
        level.addFreshEntity((Entity)yoyo);
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        DecimalFormat df = new DecimalFormat("#.#");
        double speed = 20.0 / (double)this.cooldown;
        String speedTime = df.format(speed);
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.yoyo.damage", (Object[])new Object[]{this.damage}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.yoyo.speed", (Object[])new Object[]{speedTime}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.yoyo.string", (Object[])new Object[]{this.stringLength}).withStyle(ChatFormatting.GRAY));
    }

    public int getStringLength() {
        return this.stringLength;
    }
}

