/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.rosebushes.alchemyexpanded.entity.AppearifierProjectileEntity;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AppearifierGunWeaponItem
extends GunWeaponItem {
    public AppearifierGunWeaponItem(Item.Properties properties, double speed, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, Item ammo, @Nullable Item iDouble) {
        super(properties, 0.0f, speed, 1, spread, rate, ammoCap, ammoConsumption, reload, infinite, false, ammo, iDouble);
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        AppearifierProjectileEntity appear = new AppearifierProjectileEntity(level, (LivingEntity)shooter);
        appear.setWeapon(stack);
        appear.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
        appear.setDamage(this.getWeaponDamage());
        level.addFreshEntity((Entity)appear);
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)0.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int rate = this.getRate();
        double reloadTime = (double)Math.round((double)this.getReload(stack) * 0.05 * 2.0) / 2.0;
        int ammoCap = this.getAmmo(stack);
        int ammoConsumption = this.getAmmoConsume();
        double timeFireClip = (double)rate * 0.05 * (double)ammoCap;
        double ratePerMinuteWithReload = 60.0 / (timeFireClip + reloadTime);
        double roundsPerMinuteFired = ratePerMinuteWithReload * (double)ammoCap;
        String ammoType = this.getAmmoType().getDescriptionId();
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.reload_time", (Object[])new Object[]{reloadTime}).withStyle(ChatFormatting.GRAY));
        if (!this.getInfinite()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_max", (Object[])new Object[]{ammoCap}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_consume", (Object[])new Object[]{ammoConsumption}).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)ammoType).withStyle(ChatFormatting.GRAY)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.infinite").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD));
        }
        if (roundsPerMinuteFired <= 50.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_very_slow").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 100.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_slow").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 150.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_medium").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_fast").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD)));
        }
    }
}

