/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.google.common.util.concurrent.AtomicDouble;
import com.rosebushes.alchemyexpanded.entity.BarbasolBombProjectileEntity;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantmentEffects;
import com.rosebushes.alchemyexpanded.item.enchantments.FirepowerEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class BarbasolLauncherGunWeaponItem
extends GunWeaponItem {
    public BarbasolLauncherGunWeaponItem(Item.Properties properties, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        super(properties, damage, speed, amount, spread, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount(); ++i) {
            BarbasolBombProjectileEntity bomb = new BarbasolBombProjectileEntity(level, (LivingEntity)shooter);
            bomb.setWeapon(stack);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            bomb.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            bomb.setDamage(atomicWeaponDamage.get());
            bomb.setExplodeRadius(3.0f);
            level.addFreshEntity((Entity)bomb);
        }
    }
}

