/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.mraof.minestuck.item.MSItems;
import com.rosebushes.alchemyexpanded.entity.CueballProjectileEntity;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class CueballGunWeaponItem
extends GunWeaponItem {
    public CueballGunWeaponItem(Item.Properties properties, double speed, float spread, int rate, int reload, Item iDouble) {
        super(properties, 0.0f, speed, 1, spread, rate, 1, 1, reload, false, false, (Item)MSItems.CUEBALL.get(), iDouble);
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        CueballProjectileEntity cueball = new CueballProjectileEntity(level, (LivingEntity)shooter);
        cueball.setWeapon(stack);
        cueball.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
        cueball.setDamage(this.getWeaponDamage());
        level.addFreshEntity((Entity)cueball);
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)0.0f, (float)0.0f, (float)1.0f);
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        double reloadTime = (double)Math.round((double)this.getReload(stack) * 0.05 * 2.0) / 2.0;
        int ammoConsumption = this.getAmmoConsume();
        String ammoType = this.getAmmoType().getDescriptionId();
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_one").withStyle(ChatFormatting.WHITE));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.reload_time", (Object[])new Object[]{reloadTime}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_consume", (Object[])new Object[]{ammoConsumption}).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)ammoType).withStyle(ChatFormatting.WHITE)));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_perfect").withStyle(ChatFormatting.WHITE).withStyle(ChatFormatting.BOLD)));
    }
}

