/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.google.common.util.concurrent.AtomicDouble;
import com.rosebushes.alchemyexpanded.entity.EffectCloudProjectileEntity;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantmentEffects;
import com.rosebushes.alchemyexpanded.item.enchantments.FirepowerEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EffectCloudGunWeaponItem
extends GunWeaponItem {
    protected int cloudDuration;
    protected int cloudRadius;
    protected int cloudColor;
    protected Potion cloudEffect;
    protected SimpleParticleType particle;

    public EffectCloudGunWeaponItem(Item.Properties properties, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, int cDuraton, int cRadius, int cColor, SimpleParticleType particle, Potion cEffect, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        super(properties, damage, speed, amount, spread, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
        this.cloudDuration = cDuraton;
        this.cloudRadius = cRadius;
        this.cloudColor = cColor;
        this.cloudEffect = cEffect;
        this.particle = particle;
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount(); ++i) {
            EffectCloudProjectileEntity cloudBullet = new EffectCloudProjectileEntity(level, (LivingEntity)shooter);
            cloudBullet.setWeapon(stack);
            cloudBullet.setDuration(this.getCloudDuration());
            cloudBullet.setRadius(this.getCloudRadius());
            cloudBullet.setColor(this.getCloudColor());
            cloudBullet.setPotionEffect(this.getCloudEffect());
            cloudBullet.setParticle(this.particle);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            cloudBullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            cloudBullet.setDamage(atomicWeaponDamage.get());
            level.addFreshEntity((Entity)cloudBullet);
        }
    }

    @Override
    public void shootDouble(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount() + this.getAmount(); ++i) {
            EffectCloudProjectileEntity cloudBullet = new EffectCloudProjectileEntity(level, (LivingEntity)shooter);
            double dualWieldBonus = (float)Math.round(this.getWeaponDamage() / 10.0f * 2.0f) / 2.0f;
            cloudBullet.setWeapon(stack);
            cloudBullet.setDuration(this.getCloudDuration());
            cloudBullet.setRadius(this.getCloudRadius());
            cloudBullet.setColor(this.getCloudColor());
            cloudBullet.setPotionEffect(this.getCloudEffect());
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            cloudBullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            cloudBullet.setDamage(atomicWeaponDamage.get() + dualWieldBonus);
            level.addFreshEntity((Entity)cloudBullet);
        }
    }

    public int getCloudDuration() {
        return this.cloudDuration;
    }

    public int getCloudRadius() {
        return this.cloudRadius;
    }

    public int getCloudColor() {
        return this.cloudColor;
    }

    public Potion getCloudEffect() {
        return this.cloudEffect;
    }
}

