/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.google.common.util.concurrent.AtomicDouble;
import com.rosebushes.alchemyexpanded.entity.FlareProjectileEntity;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantmentEffects;
import com.rosebushes.alchemyexpanded.item.enchantments.FirepowerEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FlareGunWeaponItem
extends GunWeaponItem {
    public FlareGunWeaponItem(Item.Properties properties, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        super(properties, damage, speed, amount, spread, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount(); ++i) {
            FlareProjectileEntity flare = new FlareProjectileEntity(level, (LivingEntity)shooter);
            flare.setWeapon(stack);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            flare.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            flare.setDamage(atomicWeaponDamage.get());
            flare.setTargetFireSeconds(5);
            level.addFreshEntity((Entity)flare);
        }
    }

    @Override
    public void shootDouble(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount() + this.getAmount(); ++i) {
            FlareProjectileEntity flare = new FlareProjectileEntity(level, (LivingEntity)shooter);
            double dualWieldBonus = (float)Math.round(this.getWeaponDamage() / 10.0f * 2.0f) / 2.0f;
            flare.setWeapon(stack);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            flare.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            flare.setDamage(atomicWeaponDamage.get() + dualWieldBonus);
            flare.setTargetFireSeconds(5);
            level.addFreshEntity((Entity)flare);
        }
    }
}

