/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.google.common.util.concurrent.AtomicDouble;
import com.rosebushes.alchemyexpanded.entity.ProjectileEntity;
import com.rosebushes.alchemyexpanded.item.components.AEItemComponents;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantmentEffects;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantments;
import com.rosebushes.alchemyexpanded.item.enchantments.AmmoUpEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.enchantments.FirepowerEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.enchantments.QuickLoadEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.enchantments.SpareShotEnchantmentEffect;
import com.rosebushes.alchemyexpanded.util.AESoundEvents;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class GunWeaponItem
extends Item {
    private float projectileDamage;
    private double projectileSpeed;
    private int projectileAmount;
    private float projectileSpread;
    private int fireRate;
    private int ammoMax;
    private int reloadSpeed;
    private boolean useAmmo;
    private int ammoConsume;
    private boolean canDualWield;
    private Item ammoType;
    private Item innocuousDouble;

    public GunWeaponItem(Item.Properties properties) {
        super(properties);
    }

    public GunWeaponItem(Item.Properties properties, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        this(properties);
        this.projectileDamage = damage;
        this.projectileSpeed = speed;
        this.projectileAmount = amount;
        this.projectileSpread = spread;
        this.fireRate = rate;
        this.ammoMax = ammoCap;
        this.ammoConsume = ammoConsumption;
        this.reloadSpeed = reload;
        this.useAmmo = infinite;
        this.canDualWield = dualWield;
        this.ammoType = ammo;
        this.innocuousDouble = iDouble;
    }

    public int getBarWidth(ItemStack stack) {
        return Math.round(13.0f * (float)this.getAmmoCurrent(stack) / (float)this.getAmmo(stack));
    }

    public int getBarColor(ItemStack stack) {
        return 6732543;
    }

    public boolean isBarVisible(ItemStack stack) {
        return !this.getInfinite();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        boolean mainHand = usedHand == InteractionHand.MAIN_HAND;
        ItemStack gun = player.getItemInHand(usedHand);
        ItemStack offHandItem = mainHand ? player.getItemInHand(InteractionHand.OFF_HAND) : player.getItemInHand(InteractionHand.MAIN_HAND);
        boolean offHandEmpty = offHandItem.isEmpty();
        boolean offHandSameItem = offHandItem.getItem() == gun.getItem();
        AtomicDouble atomicAmmoUse = new AtomicDouble(0.0);
        EnchantmentHelper.runIterationOnItem((ItemStack)gun, (enchantmentHolder, enchantLevel) -> {
            SpareShotEnchantmentEffect spareShotEnchantmentEffect = (SpareShotEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.SPARE_SHOT.get());
            if (spareShotEnchantmentEffect != null) {
                atomicAmmoUse.set((double)spareShotEnchantmentEffect.process(enchantLevel, level.random, 1.0f));
            }
        });
        if (!mainHand && !offHandEmpty && offHandItem.getItem() instanceof GunWeaponItem && !this.getDualWieldable()) {
            return InteractionResultHolder.fail((Object)gun);
        }
        if (!this.getInnocuousDouble().isEmpty() && player.isShiftKeyDown() && this.getAmmoCurrent(gun) > 0) {
            ItemStack newItem = this.getInnocuousDouble();
            newItem.set(AEItemComponents.GUN_AMMO_COUNT, (Object)((Integer)gun.getOrDefault(AEItemComponents.GUN_AMMO_COUNT, (Object)this.getAmmoCurrent(gun))));
            newItem.set(AEItemComponents.GUN_COOLDOWN_FIRE, (Object)((Integer)gun.getOrDefault(AEItemComponents.GUN_COOLDOWN_FIRE, (Object)this.getLocalFireCooldown(gun))));
            newItem.set(AEItemComponents.GUN_COOLDOWN_RELOAD, (Object)((Integer)gun.getOrDefault(AEItemComponents.GUN_COOLDOWN_RELOAD, (Object)this.getLocalReloadCooldown(gun))));
            return InteractionResultHolder.success((Object)newItem);
        }
        if (this.getLocalReloadCooldown(gun) > 0) {
            double reloadCooldown = (double)this.getLocalReloadCooldown(gun) * 0.05;
            int wholeSeconds = (int)Math.rint(reloadCooldown);
            if (!level.isClientSide) {
                MutableComponent message = Component.translatable((String)"message.alchemyexpanded.gun.cooldown", (Object[])new Object[]{wholeSeconds}).withStyle(ChatFormatting.RED);
                player.displayClientMessage((Component)message, true);
            }
            return InteractionResultHolder.fail((Object)gun);
        }
        if (!(this.getAmmoCurrent(gun) > 0 || this.getInfinite() || player.getAbilities().instabuild || player.isShiftKeyDown())) {
            if (!level.isClientSide()) {
                MutableComponent message = Component.translatable((String)"message.alchemyexpanded.gun.empty");
                player.sendSystemMessage((Component)message.withStyle(ChatFormatting.RED));
            }
            this.playAmmoEmptySound(level, (Entity)player);
            return InteractionResultHolder.fail((Object)gun);
        }
        if (this.getAmmoCurrent(gun) <= 0 && player.isShiftKeyDown() && !this.getInfinite() && !player.getAbilities().instabuild) {
            ItemStack ammoInv = GunWeaponItem.findItem(player, this.getAmmoType());
            ItemStack ammoSecond = GunWeaponItem.findItemWithCount(player, this.getAmmoType(), this.getAmmoConsume());
            if (ammoInv != null && ammoSecond != null) {
                boolean enoughAmmoSecond;
                boolean enoughAmmo = this.getAmmoConsume() <= ammoInv.getCount();
                boolean bl = enoughAmmoSecond = ammoInv.getCount() + ammoSecond.getCount() >= this.getAmmoConsume();
                if (!enoughAmmo && !enoughAmmoSecond) {
                    if (!level.isClientSide()) {
                        MutableComponent message = Component.translatable((String)"message.alchemyexpanded.gun.need_more_ammo");
                        player.sendSystemMessage((Component)message.withStyle(ChatFormatting.DARK_RED));
                    }
                    this.playAmmoEmptySound(level, (Entity)player);
                    return InteractionResultHolder.fail((Object)gun);
                }
                if (!level.isClientSide()) {
                    MutableComponent message = Component.translatable((String)"message.alchemyexpanded.gun.reload");
                    player.sendSystemMessage((Component)message.withStyle(ChatFormatting.YELLOW));
                    this.setAmmoCurrent(gun, this.getAmmo(gun));
                }
                GunWeaponItem.removeItems(player, this.getAmmoType(), this.getAmmoConsume());
                this.setLocalReloadCooldown(gun, this.getReload(gun));
                this.playReloadSound(level, (Entity)player);
                return InteractionResultHolder.pass((Object)gun);
            }
            if (!level.isClientSide()) {
                MutableComponent message = Component.translatable((String)"message.alchemyexpanded.gun.no_ammo");
                player.sendSystemMessage((Component)message.withStyle(ChatFormatting.RED));
            }
            this.playAmmoEmptySound(level, (Entity)player);
            return InteractionResultHolder.fail((Object)gun);
        }
        int fireCooldown = this.getLocalFireCooldown(gun);
        if (!mainHand && !offHandSameItem && !offHandEmpty && offHandItem.getItem() instanceof GunWeaponItem) {
            return InteractionResultHolder.fail((Object)gun);
        }
        if (!mainHand && this.getDualWieldable() && offHandSameItem && this.getAmmoCurrent(offHandItem) <= 0) {
            if (fireCooldown > 0) {
                return InteractionResultHolder.fail((Object)gun);
            }
            if (!level.isClientSide()) {
                this.shoot(level, player, gun);
                if (!this.getInfinite() && !player.getAbilities().instabuild && atomicAmmoUse.get() == 0.0) {
                    if (this.getAmmo(gun) < this.getAmount()) {
                        this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - 1);
                    } else {
                        this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - this.getAmount());
                    }
                }
            }
            this.addParticles(level, (Entity)player, 6);
            this.setLocalFireCooldown(gun, this.getRate());
            this.playFireSound(level, (Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.pass((Object)gun);
        }
        if (!mainHand && this.getDualWieldable() && offHandSameItem) {
            if (fireCooldown > 0) {
                return InteractionResultHolder.fail((Object)gun);
            }
            if (!this.getInfinite() && !player.getAbilities().instabuild && atomicAmmoUse.get() == 0.0) {
                if (this.getAmmo(gun) < this.getAmount()) {
                    this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - 1);
                } else {
                    this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - this.getAmount());
                }
            }
            this.setLocalFireCooldown(gun, this.getRate());
            return InteractionResultHolder.pass((Object)gun);
        }
        if (!offHandSameItem || !this.getDualWieldable()) {
            if (fireCooldown > 0) {
                return InteractionResultHolder.fail((Object)gun);
            }
            if (!level.isClientSide()) {
                this.shoot(level, player, gun);
                if (!this.getInfinite() && !player.getAbilities().instabuild && atomicAmmoUse.get() == 0.0) {
                    if (this.getAmmo(gun) < this.getAmount()) {
                        this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - 1);
                    } else {
                        this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - this.getAmount());
                    }
                }
            }
            this.addParticles(level, (Entity)player, 6);
            this.setLocalFireCooldown(gun, this.getRate());
            this.playFireSound(level, (Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.pass((Object)gun);
        }
        if (fireCooldown > 0) {
            return InteractionResultHolder.fail((Object)gun);
        }
        if (!level.isClientSide()) {
            this.shootDouble(level, player, gun);
            if (!this.getInfinite() && !player.getAbilities().instabuild && atomicAmmoUse.get() == 0.0) {
                if (this.getAmmo(gun) < this.getAmount()) {
                    this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - 1);
                } else {
                    this.setAmmoCurrent(gun, this.getAmmoCurrent(gun) - this.getAmount());
                }
            }
        }
        this.setLocalFireCooldown(gun, this.getRate());
        this.addParticles(level, (Entity)player, 6);
        this.playFireSound(level, (Entity)player);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.pass((Object)gun);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 25;
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        if (enchantment.is(AEEnchantments.FIREPOWER)) {
            return true;
        }
        if (enchantment.is(AEEnchantments.QUICK_LOAD)) {
            return true;
        }
        if (enchantment.is(AEEnchantments.AMMO_UP)) {
            return true;
        }
        return enchantment.is(AEEnchantments.SPARE_SHOT);
    }

    public void shoot(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount(); ++i) {
            ProjectileEntity bullet = new ProjectileEntity(level, (LivingEntity)shooter);
            bullet.setWeapon(stack);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            bullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            bullet.setDamage((float)atomicWeaponDamage.get());
            level.addFreshEntity((Entity)bullet);
        }
    }

    public void shootDouble(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount() + this.getAmount(); ++i) {
            float dualWieldBonus = (float)Math.round(this.getWeaponDamage() / 10.0f * 2.0f) / 2.0f;
            ProjectileEntity bullet = new ProjectileEntity(level, (LivingEntity)shooter);
            bullet.setWeapon(stack);
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            bullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            bullet.setDamage((float)atomicWeaponDamage.get() + dualWieldBonus);
            level.addFreshEntity((Entity)bullet);
        }
    }

    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @javax.annotation.Nullable
    private static ItemStack findItem(Player player, Item item) {
        for (ItemStack invItem : player.getInventory().items) {
            if (!invItem.is(item)) continue;
            return invItem;
        }
        return null;
    }

    @javax.annotation.Nullable
    private static ItemStack findItemWithCount(Player player, Item item, int count) {
        for (ItemStack invItem : player.getInventory().items) {
            if (!invItem.is(item) || invItem.getCount() < count) continue;
            return invItem;
        }
        return null;
    }

    private static void removeItems(Player player, Item item, int count) {
        int removeTotal = count;
        for (int i = 0; i < 8; ++i) {
            for (ItemStack invItem : player.getInventory().items) {
                if (!invItem.is(item)) continue;
                if (removeTotal > 0) {
                    player.getInventory().removeItem(player.getInventory().findSlotMatchingItem(invItem), 1);
                    --removeTotal;
                    continue;
                }
                return;
            }
        }
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        int fireCooldown = this.getLocalFireCooldown(stack);
        int reloadCooldown = this.getLocalReloadCooldown(stack);
        if (fireCooldown <= this.getRate() && fireCooldown > 0) {
            this.setLocalFireCooldown(stack, fireCooldown - 1);
        }
        if (reloadCooldown <= this.getReload(stack) && reloadCooldown > 0) {
            this.setLocalReloadCooldown(stack, reloadCooldown - 1);
        }
    }

    public void addParticles(Level level, Entity player, int amount) {
        for (int x = 0; x <= amount; ++x) {
            Vec3 vecPlayerAngle = player.getLookAngle();
            float offsetX = (level.random.nextFloat() - 0.5f) / 4.0f;
            float offsetY = (level.random.nextFloat() - 0.5f) / 4.0f;
            float offsetZ = (level.random.nextFloat() - 0.5f) / 4.0f;
            level.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.FLAME, player.getX() + vecPlayerAngle.x + (double)offsetX, player.getY() + 1.0 + (double)offsetY, player.getZ() + vecPlayerAngle.z + (double)offsetZ, vecPlayerAngle.x / 5.0, vecPlayerAngle.y / 5.0, vecPlayerAngle.z / 5.0);
        }
    }

    public void playSound(Level level, Entity player, SoundEvent sound, float volume, float pitch) {
        level.playSound(null, player.getX(), player.getY(), player.getZ(), sound, SoundSource.PLAYERS, volume, pitch);
    }

    public void playAmmoEmptySound(Level level, Entity player) {
        this.playSound(level, player, SoundEvents.LEVER_CLICK, 1.0f, 1.0f);
    }

    public void playReloadSound(Level level, Entity player) {
        this.playSound(level, player, AESoundEvents.BASIC_GUN_RELOAD.get(), 1.0f, 1.0f);
    }

    public void playFireSound(Level level, Entity player) {
        this.playSound(level, player, AESoundEvents.BASIC_GUNSHOT.get(), 1.0f, 1.0f);
    }

    public void setAmmoCurrent(ItemStack stack, int amount) {
        stack.set(AEItemComponents.GUN_AMMO_COUNT, (Object)amount);
    }

    public int getAmmoCurrent(ItemStack stack) {
        return (Integer)stack.getOrDefault(AEItemComponents.GUN_AMMO_COUNT, (Object)this.ammoMax);
    }

    public void setLocalReloadCooldown(ItemStack stack, int amount) {
        stack.set(AEItemComponents.GUN_COOLDOWN_RELOAD, (Object)amount);
    }

    public int getLocalReloadCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(AEItemComponents.GUN_COOLDOWN_RELOAD, (Object)this.reloadSpeed);
    }

    public void setLocalFireCooldown(ItemStack stack, int amount) {
        stack.set(AEItemComponents.GUN_COOLDOWN_FIRE, (Object)amount);
    }

    public int getLocalFireCooldown(ItemStack stack) {
        return (Integer)stack.getOrDefault(AEItemComponents.GUN_COOLDOWN_FIRE, (Object)this.fireRate);
    }

    public void setWeaponDamage(float newDmg) {
        this.projectileDamage = newDmg;
    }

    public float getWeaponDamage() {
        return this.projectileDamage;
    }

    public double getSpeed() {
        return this.projectileSpeed;
    }

    public float getSpread() {
        return this.projectileSpread;
    }

    public int getAmount() {
        return this.projectileAmount;
    }

    public int getRate() {
        return this.fireRate;
    }

    public int getAmmo(ItemStack stack) {
        AtomicInteger atomicAmmoCap = new AtomicInteger(this.ammoMax);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
            AmmoUpEnchantmentEffect ammoUp = (AmmoUpEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.AMMO_UP.get());
            if (ammoUp != null) {
                for (int it = 0; it < enchantLevel; ++it) {
                    atomicAmmoCap.set(ammoUp.add(atomicAmmoCap.get()));
                }
            }
        });
        return atomicAmmoCap.get();
    }

    public int getAmmoConsume() {
        return this.ammoConsume;
    }

    public int getReload(ItemStack stack) {
        AtomicInteger atomicReload = new AtomicInteger(this.reloadSpeed);
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
            QuickLoadEnchantmentEffect quickLoad = (QuickLoadEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.QUICK_LOAD.get());
            if (quickLoad != null) {
                for (int it = 0; it < enchantLevel; ++it) {
                    atomicReload.set(quickLoad.subtract(atomicReload.get()));
                }
            }
        });
        return atomicReload.get();
    }

    public boolean getInfinite() {
        return this.useAmmo;
    }

    public boolean getDualWieldable() {
        return this.canDualWield;
    }

    public Item getAmmoType() {
        return this.ammoType;
    }

    public ItemStack getInnocuousDouble() {
        if (this.innocuousDouble != null) {
            return new ItemStack((ItemLike)this.innocuousDouble);
        }
        return ItemStack.EMPTY;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
            FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
            if (gunDamageEnchantment != null) {
                for (int it = 0; it < enchantLevel; ++it) {
                    atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                }
            }
        });
        float damage = (float)atomicWeaponDamage.get();
        int amount = this.getAmount();
        int rate = this.getRate();
        double reloadTime = (double)Math.round((double)this.getReload(stack) * 0.05 * 2.0) / 2.0;
        int ammoCap = this.getAmmo(stack);
        int ammoConsumption = this.getAmmoConsume();
        double timeFireClip = (double)rate * 0.05 * (double)ammoCap;
        double ratePerMinuteWithReload = 60.0 / (timeFireClip + reloadTime);
        double roundsPerMinuteFired = ratePerMinuteWithReload * (double)ammoCap;
        double damagePerSecond = (float)Math.round(roundsPerMinuteFired * (double)((float)amount * damage) / 60.0 * 2.0) / 2.0f;
        double ammoEfficiency = damagePerSecond * 60.0 / (ratePerMinuteWithReload * (double)ammoConsumption);
        String ammoType = this.getAmmoType().getDescriptionId();
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.damage", (Object[])new Object[]{damagePerSecond}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.amount", (Object[])new Object[]{amount}).withStyle(ChatFormatting.GRAY));
        if (!this.getInfinite()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.reload_time", (Object[])new Object[]{reloadTime}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_max", (Object[])new Object[]{ammoCap}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_consume", (Object[])new Object[]{ammoConsumption}).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)ammoType).withStyle(ChatFormatting.GRAY)));
        }
        if (ammoEfficiency <= 20.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_poor").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD)));
        } else if (ammoEfficiency <= 50.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_average").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)));
        } else if (ammoEfficiency <= 75.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_good").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_great").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD)));
        }
        if (roundsPerMinuteFired <= 50.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_very_slow").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 100.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_slow").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 150.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_medium").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_fast").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD)));
        }
        if (this.getInfinite()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.infinite").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD));
        }
        if (this.getDualWieldable()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.dual_wield").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD));
        }
    }
}

