/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.google.common.util.concurrent.AtomicDouble;
import com.mraof.minestuck.client.util.MagicEffect;
import com.mraof.minestuck.network.MagicRangedEffectPacket;
import com.rosebushes.alchemyexpanded.entity.AEDamage;
import com.rosebushes.alchemyexpanded.item.enchantments.AEEnchantmentEffects;
import com.rosebushes.alchemyexpanded.item.enchantments.FirepowerEnchantmentEffect;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import com.rosebushes.alchemyexpanded.util.AESoundEvents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class LaserGunWeaponItem
extends GunWeaponItem {
    protected int distance;
    private static final TargetingConditions visiblePredicate = TargetingConditions.forCombat();

    public LaserGunWeaponItem(Item.Properties properties, float damage, int distance, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        super(properties, damage, 0.0, 1, 0.0f, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
        this.distance = distance;
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayer) {
            this.fireLaser(stack, level, (ServerPlayer)shooter, false);
        }
    }

    @Override
    public void shootDouble(Level level, Player shooter, ItemStack stack) {
        if (shooter instanceof ServerPlayer) {
            this.fireLaser(stack, level, (ServerPlayer)shooter, true);
            this.fireLaser(stack, level, (ServerPlayer)shooter, true);
        }
    }

    private void fireLaser(ItemStack stack, Level level, ServerPlayer player, boolean dualWield) {
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getLookAngle();
        for (int step = 0; step < this.distance * 2; ++step) {
            Vec3 vecPos = eyePos.add(lookVec.scale((double)step / 2.0));
            boolean hitObstacle = this.checkCollisionInPath(stack, level, player, vecPos, dualWield);
            if (!hitObstacle) continue;
            this.sendEffectPacket(level, eyePos, lookVec, step, true);
            return;
        }
        this.sendEffectPacket(level, eyePos, lookVec, this.distance * 2, false);
    }

    protected void sendEffectPacket(Level level, Vec3 pos, Vec3 lookVec, int length, boolean collides) {
        if (!level.isClientSide) {
            PacketDistributor.sendToPlayersNear((ServerLevel)((ServerLevel)level), null, (double)pos.x, (double)pos.y, (double)pos.z, (double)64.0, (CustomPacketPayload)new MagicRangedEffectPacket(MagicEffect.RangedType.RED, pos, lookVec, length, collides), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)0.5f, (float)1.0f, (float)0.6f);
    }

    @Override
    public void playFireSound(Level level, Entity player) {
        this.playSound(level, player, AESoundEvents.LASER.get(), 1.0f, 1.0f);
    }

    @Override
    public void addParticles(Level level, Entity player, int amount) {
    }

    private boolean checkCollisionInPath(ItemStack stack, Level level, ServerPlayer player, Vec3 vecPos, boolean dualWield) {
        BlockPos blockPos = BlockPos.containing((Position)vecPos);
        if (!level.getBlockState(blockPos).isPathfindable(PathComputationType.LAND)) {
            return true;
        }
        AABB axisAlignedBB = new AABB(blockPos);
        LivingEntity closestTarget = player.level().getNearestEntity(LivingEntity.class, visiblePredicate, (LivingEntity)player, vecPos.x, vecPos.y, vecPos.z, axisAlignedBB);
        if (closestTarget != null) {
            AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
            EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
                FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
                if (gunDamageEnchantment != null) {
                    for (int it = 0; it < enchantLevel; ++it) {
                        atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                    }
                }
            });
            boolean bonusDamage = dualWield ? closestTarget.hurt(AEDamage.laser(player.level().registryAccess(), (Entity)player), (float)atomicWeaponDamage.get() + (float)Math.round(atomicWeaponDamage.get() / 10.0 * 2.0) / 2.0f) : closestTarget.hurt(AEDamage.laser(player.level().registryAccess(), (Entity)player), (float)atomicWeaponDamage.get());
            this.onHitEntity(closestTarget);
            return true;
        }
        return false;
    }

    public void onHitEntity(LivingEntity entity) {
    }

    @Override
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        int rate = this.getRate();
        double reloadTime = (double)Math.round((double)this.getReload(stack) * 0.05 * 2.0) / 2.0;
        int ammoCap = this.getAmmo(stack);
        int ammoConsumption = this.getAmmoConsume();
        double timeFireClip = (double)rate * 0.05 * (double)ammoCap;
        double ratePerMinuteWithReload = 60.0 / (timeFireClip + reloadTime);
        double roundsPerMinuteFired = ratePerMinuteWithReload * (double)ammoCap;
        AtomicDouble atomicWeaponDamage = new AtomicDouble((double)this.getWeaponDamage());
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantmentHolder, enchantLevel) -> {
            FirepowerEnchantmentEffect gunDamageEnchantment = (FirepowerEnchantmentEffect)((Enchantment)enchantmentHolder.value()).effects().get((DataComponentType)AEEnchantmentEffects.FIREPOWER.get());
            if (gunDamageEnchantment != null) {
                for (int it = 0; it < enchantLevel; ++it) {
                    atomicWeaponDamage.set((double)gunDamageEnchantment.multiply((float)atomicWeaponDamage.get()));
                }
            }
        });
        double damagePerSecond = (float)Math.round(roundsPerMinuteFired * atomicWeaponDamage.get() / 60.0 * 2.0) / 2.0f;
        double ammoEfficiency = damagePerSecond * 60.0 / (ratePerMinuteWithReload * (double)ammoConsumption);
        String ammoType = this.getAmmoType().getDescriptionId();
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.damage", (Object[])new Object[]{damagePerSecond}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.reload_time", (Object[])new Object[]{reloadTime}).withStyle(ChatFormatting.GRAY));
        if (!this.getInfinite()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_max", (Object[])new Object[]{ammoCap}).withStyle(ChatFormatting.GRAY));
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_consume", (Object[])new Object[]{ammoConsumption}).withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)ammoType).withStyle(ChatFormatting.GRAY)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.infinite").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD));
        }
        if (ammoEfficiency <= 20.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_poor").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD)));
        } else if (ammoEfficiency <= 50.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_average").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)));
        } else if (ammoEfficiency <= 75.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_good").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.ammo_eff_great").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD)));
        }
        if (roundsPerMinuteFired <= 50.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_very_slow").withStyle(ChatFormatting.DARK_RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 100.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_slow").withStyle(ChatFormatting.RED).withStyle(ChatFormatting.BOLD)));
        } else if (roundsPerMinuteFired <= 150.0) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_medium").withStyle(ChatFormatting.YELLOW).withStyle(ChatFormatting.BOLD)));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate").withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)"info.alchemyexpanded.gun.rate_fast").withStyle(ChatFormatting.GREEN).withStyle(ChatFormatting.BOLD)));
        }
        if (this.getDualWieldable()) {
            tooltipComponents.add((Component)Component.translatable((String)"info.alchemyexpanded.gun.dual_wield").withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.BOLD));
        }
    }
}

