/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class SwordGunWeaponItem
extends GunWeaponItem {
    private final int meleeDamage;
    private final float attackSpeed;
    private final ItemAttributeModifiers modifiers;

    public SwordGunWeaponItem(Item.Properties properties, int melDmg, float atkSpeed, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble) {
        super(properties, damage, speed, amount, spread, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
        this.meleeDamage = melDmg;
        this.attackSpeed = atkSpeed;
        ItemAttributeModifiers tempModifiers = ItemAttributeModifiers.EMPTY;
        tempModifiers = tempModifiers.withModifierAdded(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemyexpanded", (String)"gunblade_attack_damage_modifier"), (double)this.meleeDamage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        this.modifiers = tempModifiers = tempModifiers.withModifierAdded(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"alchemyexpanded", (String)"gunblade_attack_speed_modifier"), (double)this.attackSpeed, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            target.hurt(attacker.damageSources().playerAttack((Player)attacker), (float)this.meleeDamage);
        } else {
            target.hurt(attacker.damageSources().mobAttack(attacker), (float)this.meleeDamage);
        }
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        return true;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(Blocks.COBWEB)) {
            return 15.0f;
        }
        return state.is(BlockTags.SWORD_EFFICIENT) ? 1.5f : 1.0f;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        if (state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            stack.hurtAndBreak(2, miningEntity, EquipmentSlot.MAINHAND);
        }
        return super.mineBlock(stack, level, state, pos, miningEntity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(Blocks.COBWEB);
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return this.modifiers;
    }

    public int getMeleeDamage() {
        return this.meleeDamage;
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }
}

