/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.item.weapon.gun;

import com.rosebushes.alchemyexpanded.entity.TeleportProjectileEntity;
import com.rosebushes.alchemyexpanded.item.weapon.gun.GunWeaponItem;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class TeleportGunWeaponItem
extends GunWeaponItem {
    protected int teleportXMin;
    protected int teleportXMax;
    protected int teleportY;
    protected int teleportZMin;
    protected int teleportZMax;

    public TeleportGunWeaponItem(Item.Properties properties, float damage, double speed, int amount, float spread, int rate, int ammoCap, int ammoConsumption, int reload, boolean infinite, boolean dualWield, Item ammo, @Nullable Item iDouble, int tpXMin, int tpXMax, int tpY, int tpZMin, int tpZMax) {
        super(properties, damage, speed, amount, spread, rate, ammoCap, ammoConsumption, reload, infinite, dualWield, ammo, iDouble);
        this.teleportXMin = tpXMin;
        this.teleportXMax = tpXMax;
        this.teleportY = tpY;
        this.teleportZMin = tpZMin;
        this.teleportZMax = tpZMax;
    }

    @Override
    public void shoot(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount(); ++i) {
            TeleportProjectileEntity bullet = new TeleportProjectileEntity(level, (LivingEntity)shooter);
            bullet.setWeapon(stack);
            bullet.setTeleportAmount(this.getTeleportXMin(), this.getTeleportXMax(), this.getTeleportY(), this.getTeleportZMin(), this.getTeleportZMax());
            bullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            bullet.setDamage(this.getWeaponDamage());
            level.addFreshEntity((Entity)bullet);
        }
    }

    @Override
    public void shootDouble(Level level, Player shooter, ItemStack stack) {
        for (int i = 0; i < this.getAmount() + this.getAmount(); ++i) {
            TeleportProjectileEntity bullet = new TeleportProjectileEntity(level, (LivingEntity)shooter);
            double dualWieldBonus = (float)Math.round(this.getWeaponDamage() / 10.0f * 2.0f) / 2.0f;
            bullet.setWeapon(stack);
            bullet.setTeleportAmount(this.getTeleportXMin(), this.getTeleportXMax(), this.getTeleportY(), this.getTeleportZMin(), this.getTeleportZMax());
            bullet.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, (float)this.getSpeed(), this.getSpread());
            bullet.setDamage((double)this.getWeaponDamage() + dualWieldBonus);
            level.addFreshEntity((Entity)bullet);
        }
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return Mth.hsvToRgb((float)0.2f, (float)1.0f, (float)1.0f);
    }

    public int getTeleportXMin() {
        return this.teleportXMin;
    }

    public int getTeleportXMax() {
        return this.teleportXMax;
    }

    public int getTeleportY() {
        return this.teleportY;
    }

    public int getTeleportZMin() {
        return this.teleportZMin;
    }

    public int getTeleportZMax() {
        return this.teleportZMax;
    }
}

