/*
 * Decompiled with CFR 0.152.
 */
package com.rosebushes.alchemyexpanded.util;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DiceEffectHelper {
    protected static final MobEffectInstance rollTwo = new MobEffectInstance(MobEffects.HARM, 20);
    protected static final MobEffectInstance rollThree = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1);
    protected static final MobEffectInstance rollFour = new MobEffectInstance(MobEffects.INVISIBILITY, 120);
    protected static final MobEffectInstance rollFive = new MobEffectInstance(MobEffects.HEAL, 20);
    protected static final MobEffectInstance rollSix = new MobEffectInstance(MobEffects.SLOW_FALLING, 120);
    protected static final MobEffectInstance rollSeven = new MobEffectInstance(MobEffects.LEVITATION, 60);
    protected static final MobEffectInstance rollEight = new MobEffectInstance(MobEffects.LUCK, 120, 1);
    protected static final MobEffectInstance rollNine = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, 1);
    protected static final MobEffectInstance rollTen = new MobEffectInstance(MobEffects.REGENERATION, 80, 1);
    protected static final MobEffectInstance rollMaxUserDamage = new MobEffectInstance(MobEffects.DAMAGE_BOOST, 80, 2);
    protected static final MobEffectInstance rollMaxUserReduction = new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 80, 2);
    protected static final MobEffectInstance rollMaxTarget = new MobEffectInstance(MobEffects.HARM, 20, 4);

    public float getDiceDamage(int amount, int value, int damage, LivingEntity user, LivingEntity target, boolean enchanted) {
        Random random = new Random();
        int totalDamage = 0;
        int[] previousRolls = new int[amount];
        ArrayList<MobEffectInstance> rollList = new ArrayList<MobEffectInstance>();
        rollList.add(rollTwo);
        rollList.add(rollThree);
        rollList.add(rollFour);
        rollList.add(rollFive);
        rollList.add(rollSix);
        rollList.add(rollSeven);
        rollList.add(rollEight);
        rollList.add(rollNine);
        rollList.add(rollTen);
        for (int i = 0; i < amount; ++i) {
            int roll = random.nextInt(value);
            if (roll < 1) {
                roll = 1;
            }
            if (user.hasEffect(MobEffects.LUCK) && roll < value) {
                int luckBonus = 0;
                luckBonus = user.getEffect(MobEffects.LUCK).getAmplifier() + 1;
                if ((roll += luckBonus) > value) {
                    roll = value;
                }
            }
            int prev = this.checkPreviousSameRolls(previousRolls, roll);
            if (enchanted) {
                if (prev == 0) {
                    this.addRollEffect(user, target, roll, value, random, rollList);
                } else {
                    this.addRollBonusEffect(user, target, roll, value, random, prev, rollList);
                }
                if (prev == value - 1 && roll == value) {
                    this.addMaxRollAllEffect(user, target);
                }
            }
            totalDamage += damage * roll;
            if (prev == value - 1 && roll == value) {
                totalDamage *= 4;
            }
            previousRolls[i] = roll;
        }
        if (user instanceof Player) {
            this.sendRollsMessage(previousRolls, (Player)user);
        }
        return totalDamage;
    }

    public void addRollEffect(LivingEntity user, LivingEntity target, int roll, int value, Random random, ArrayList<MobEffectInstance> rollList) {
        if (!target.level().isClientSide()) {
            for (MobEffectInstance i : rollList) {
                if (rollList.get(roll) != i) continue;
                if (i == rollTwo) {
                    target.addEffect(new MobEffectInstance(rollTwo));
                    continue;
                }
                if (i == rollThree) {
                    target.addEffect(new MobEffectInstance(rollThree));
                    continue;
                }
                if (i == rollFour) {
                    user.addEffect(new MobEffectInstance(rollFour));
                    continue;
                }
                if (i == rollFive) {
                    user.addEffect(new MobEffectInstance(rollFive));
                    continue;
                }
                if (i == rollSix) {
                    user.addEffect(new MobEffectInstance(rollSix));
                    continue;
                }
                if (i == rollSeven) {
                    target.addEffect(new MobEffectInstance(rollSeven));
                    continue;
                }
                if (i == rollEight) {
                    user.addEffect(new MobEffectInstance(rollEight));
                    continue;
                }
                if (i == rollNine) {
                    user.addEffect(new MobEffectInstance(rollNine));
                    continue;
                }
                if (i != rollTen) continue;
                user.addEffect(new MobEffectInstance(rollTen));
            }
        }
    }

    public void addRollBonusEffect(LivingEntity user, LivingEntity target, int roll, int value, Random random, int prevSame, ArrayList<MobEffectInstance> rollList) {
        if (!target.level().isClientSide()) {
            for (MobEffectInstance i : rollList) {
                if (rollList.get(roll) != i) continue;
                if (i == rollTwo) {
                    MobEffectInstance newTwo = new MobEffectInstance(MobEffects.HARM, 20, prevSame);
                    if (target.hasEffect(MobEffects.HARM)) {
                        target.removeEffect(MobEffects.HARM);
                    }
                    target.addEffect(new MobEffectInstance(newTwo));
                    continue;
                }
                if (i == rollThree) {
                    MobEffectInstance newThree = new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, prevSame);
                    if (target.hasEffect(MobEffects.MOVEMENT_SLOWDOWN)) {
                        target.removeEffect(MobEffects.MOVEMENT_SLOWDOWN);
                    }
                    target.addEffect(new MobEffectInstance(newThree));
                    continue;
                }
                if (i == rollFour) {
                    MobEffectInstance newFour = new MobEffectInstance(MobEffects.INVISIBILITY, 60 * prevSame + 60);
                    if (user.hasEffect(MobEffects.INVISIBILITY)) {
                        user.removeEffect(MobEffects.INVISIBILITY);
                    }
                    user.addEffect(new MobEffectInstance(newFour));
                    continue;
                }
                if (i == rollFive) {
                    MobEffectInstance newFive = new MobEffectInstance(MobEffects.HEAL, 20, prevSame);
                    if (user.hasEffect(MobEffects.HEAL)) {
                        user.removeEffect(MobEffects.HEAL);
                    }
                    user.addEffect(new MobEffectInstance(newFive));
                    continue;
                }
                if (i == rollSix) {
                    MobEffectInstance newSix = new MobEffectInstance(MobEffects.SLOW_FALLING, 60 * prevSame + 60);
                    if (user.hasEffect(MobEffects.SLOW_FALLING)) {
                        user.removeEffect(MobEffects.SLOW_FALLING);
                    }
                    user.addEffect(new MobEffectInstance(newSix));
                    continue;
                }
                if (i == rollSeven) {
                    MobEffectInstance newSeven = new MobEffectInstance(MobEffects.LEVITATION, 30 * prevSame + 30);
                    if (target.hasEffect(MobEffects.LEVITATION)) {
                        target.removeEffect(MobEffects.LEVITATION);
                    }
                    target.addEffect(new MobEffectInstance(newSeven));
                    continue;
                }
                if (i == rollEight) {
                    MobEffectInstance newEight = new MobEffectInstance(MobEffects.LUCK, 120, prevSame);
                    if (user.hasEffect(MobEffects.LUCK)) {
                        user.removeEffect(MobEffects.LUCK);
                    }
                    user.addEffect(new MobEffectInstance(newEight));
                    continue;
                }
                if (i == rollNine) {
                    MobEffectInstance newNine = new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 120, prevSame);
                    if (user.hasEffect(MobEffects.MOVEMENT_SPEED)) {
                        user.removeEffect(MobEffects.MOVEMENT_SPEED);
                    }
                    user.addEffect(new MobEffectInstance(newNine));
                    continue;
                }
                if (i != rollTen) continue;
                MobEffectInstance newTen = new MobEffectInstance(MobEffects.REGENERATION, 120, prevSame);
                if (user.hasEffect(MobEffects.REGENERATION)) {
                    user.removeEffect(MobEffects.REGENERATION);
                }
                user.addEffect(new MobEffectInstance(newTen));
            }
        }
    }

    public void addMaxRollAllEffect(LivingEntity user, LivingEntity target) {
        if (!user.level().isClientSide()) {
            user.addEffect(new MobEffectInstance(rollMaxUserDamage));
            user.addEffect(new MobEffectInstance(rollMaxUserReduction));
            target.addEffect(new MobEffectInstance(rollMaxTarget));
        }
    }

    protected int checkPreviousSameRolls(int[] prev, int roll) {
        int totalSame = 0;
        for (int i : prev) {
            if (roll != i) continue;
            ++totalSame;
        }
        return totalSame;
    }

    protected void sendRollsMessage(int[] prev, Player user) {
        MutableComponent component = Component.translatable((String)"info.alchemyexpanded.dice.roll");
        for (int i : prev) {
            MutableComponent comp = component;
            component = comp.copy().append((Component)Component.literal((String)(String.valueOf(i) + " ")));
        }
        MutableComponent comp = component;
        component = comp.copy().append((Component)Component.literal((String)"."));
        user.sendSystemMessage((Component)component);
    }
}

