/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.endermanoverhaul.common.entities.base;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.alexnijjar.endermanoverhaul.common.config.EndermanOverhaulConfig;
import tech.alexnijjar.endermanoverhaul.common.entities.base.BaseEnderman;

public abstract class PassiveEnderman
extends BaseEnderman {
    public PassiveEnderman(EntityType<? extends EnderMan> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 0.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(10, (Goal)new BaseEnderman.EndermanLeaveBlockGoal());
        this.goalSelector.addGoal(11, (Goal)new BaseEnderman.EndermanTakeBlockGoal());
        this.targetSelector.addGoal(1, (Goal)new BaseEnderman.EndermanLookForPlayerGoal(this::isAngryAt));
    }

    @Nullable
    public LivingEntity getTarget() {
        return null;
    }

    public boolean isAngryAt(@NotNull LivingEntity entity) {
        return false;
    }

    public boolean isCreepy() {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return EndermanOverhaulConfig.friendlyEndermanDespawn;
    }

    @Override
    protected boolean teleport() {
        if (!EndermanOverhaulConfig.friendlyEndermanTeleport) {
            return false;
        }
        return super.teleport();
    }

    @Override
    public boolean canTeleport() {
        return EndermanOverhaulConfig.friendlyEndermanTeleport;
    }

    public boolean randomTeleport(double x, double y, double z, boolean broadcastTeleport) {
        if (!EndermanOverhaulConfig.friendlyEndermanTeleport) {
            return false;
        }
        return super.randomTeleport(x, y, z, broadcastTeleport);
    }
}

