// priority: 48

//change the salt values in generateCaptchas() and do not share with players in order to avoid reverse engineering

const CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789!?";

// Ter
const STOP_CODON = 'TAG';
// Met
const START_CODON = 'ATG';

const CODONS = [
  ['A', 'GCT'],
  ['B', 'GCA'],
  ['C', 'TGT'],
  ['D', 'GAT'],
  ['E', 'GAA'],
  ['F', 'TTT'],
  ['G', 'GGT'],
  ['H', 'CAT'],
  ['I', 'ATT'],
  ['J', 'GGA'],
  ['K', 'AAA'],
  ['L', 'TTA'],
  ['M', 'AGC'],
  ['N', 'AAT'],
  ['O', 'CTA'],
  ['P', 'CCT'],
  ['Q', 'CAA'],
  ['R', 'CGT'],
  ['S', 'TCT'],
  ['T', 'ACT'],
  ['U', 'AGA'],
  ['V', 'GTT'],
  ['W', 'TGG'],
  ['X', 'AGT'],
  ['Y', 'TAT'],
  ['Z', 'ATA'],
  ['a', 'GCC'],
  ['b', 'GCG'],
  ['c', 'TGC'],
  ['d', 'GAC'],
  ['e', 'GAG'],
  ['f', 'TTC'],
  ['g', 'GGC'],
  ['h', 'CAC'],
  ['i', 'ATC'],
  ['j', 'GGG'],
  ['k', 'AAG'],
  ['l', 'TTG'],
  ['m', 'ACA'],
  ['n', 'AAC'],
  ['o', 'CTG'],
  ['p', 'CCC'],
  ['q', 'CAG'],
  ['r', 'CGC'],
  ['s', 'TCC'],
  ['t', 'ACC'],
  ['u', 'TGA'],
  ['v', 'GTC'],
  ['w', 'TAG'],
  ['x', 'AGT'],
  ['y', 'TAC'],
  ['z', 'CTC'],
  ['0', 'GTA'],
  ['1', 'CGG'],
  ['2', 'TCG'],
  ['3', 'ACG'],
  ['4', 'GTG'],
  ['5', 'CTT'],
  ['6', 'CCA'],
  ['7', 'CGA'],
  ['8', 'TCA'],
  ['9', 'UUU'],
  ['!', 'AUA'],
  ['?', 'GUG']
];

const NUCLEOTIDES = ['A', 'T', 'C', 'G'];

/**
 * creates a random sequence between 21 and 205 units long
 */
function randSequence(salt1In, salt2In) {
  let randomString = '';
  let randNum = 777777777777 + salt1In * salt2In;
  for (let i = 0; i < 21 + (randNum % 184); i++) {
    randNum += 777777 + salt1In + salt2In - i;
    randomString += NUCLEOTIDES[randNum % 4];
  }
  //console.log(`${randomString.length}`);
  return randomString;
};

function encodedSequence(captchaIn) {
  let string = '';
  //console.log(`${captchaIn}`);
  for (let i = 0; i < 8; i++) {
    let captchaChar = captchaIn.charAt(i);
    let charCodon = CODONS[CODONS.findIndex(a => a[0] == captchaChar)][1];
    //console.log(`${captchaChar} = ${charCodon}`);
    string += charCodon;
  }
  //console.log(`${string}`);
  return string;
};

function generateShuffledSequence(captchaIn, salt1In, salt2In) {
  let sequenceString = randSequence(salt1In, salt2In);
  //sequenceString += '   ';
  sequenceString += START_CODON;
  //sequenceString += '   ';
  sequenceString += encodedSequence(captchaIn);
  //sequenceString += '   ';
  sequenceString += STOP_CODON;
  //sequenceString += '   ';
  sequenceString += randSequence(salt1In - 777, salt2In + 333);

  //50% chance to flip
  if (salt1In % 2 == 1) {
    let reverseString = sequenceString.split("").reverse().join("");
    let nucFlipString = '';
    for (let char of reverseString.split("")) {
      char = char.toString().replace('A', '1').replace('T', '2').replace('C', '3').replace('G', '4');
      nucFlipString += char.replace('1', 'T').replace('2', 'A').replace('3', 'G').replace('4', 'C');
    }
    sequenceString = nucFlipString;
    //sequenceString = sequenceString.split("").replace('A', '1').replace('T', '2').replace('C', '3').replace('G', '4').join("");
    //sequenceString = sequenceString.split("").replace('1', 'T').replace('2', 'A').replace('3', 'G').replace('4', 'C').join("");
    //console.log(`flipped ${captchaIn}`);
  }

  //console.log(`${captchaIn} for ${sequenceString}`);

  return sequenceString.toString();
};

function newLine(textIn) {
  return { text: `${textIn}`, foreground: "fffffffffffffffffffffffff" };
}

function lootEntries(captchas, salt1, salt2) {
  let entriesIn = [];
  //console.log(`entriesIn: ${entriesIn.toString()}`);
  let iterate = 973;
  for (let [captcha, item] of captchas) {
    let sequence = generateShuffledSequence(captcha, salt1 + iterate, salt2 + iterate);
    let linesIn = [];
    //let text = sequence + ' '.repeat(526 - sequence.length);
    let text = sequence + ' '.repeat(526);
    for (let j = 0; j < 21; j++) {
      linesIn.push(newLine(text.substring((j * 25), j * 25 + 25)));
    }
    let entry = lootItemEntry('computercraft:printed_page', 1, {
      "minecraft:lore": [
        `\"Chromosome 5 fragment ${iterate}\"`
      ],
      "computercraft:printout": {
        lines: linesIn
      }
    });
    //console.log(`${captcha} for ${entry.toString()}`);
    entriesIn.push(entry);
    iterate += 1;
  }
  return entriesIn;
}

function randomizeCaptcha(captchaIn, salt1In, salt2In, salt3In) {
  let randomString = '';
  let charCombine = 777;

  for (let i = 0; i < 8; i++) {
    charCombine += captchaIn.codePointAt(i) * salt3In;
    let combined = (charCombine + salt1In * salt2In);
    randomString += CHARACTERS.charAt(combined % CHARACTERS.length);
  }

  //console.log(randomString);

  return randomString;
};





////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

const generateCaptchas = function (event) {
  console.log('Started generating custom data in captchas. If no finish log, then something may be broken!');

  let salt1 = 197371;
  let salt2 = 7999993;
  let salt3 = 7.27;

  let captchas = [
    //royal_deringer handled via season_x
    [randomizeCaptcha('SPclNEdl', salt1, salt2, salt3), 'minestuck:quill_of_echidna'],
    [randomizeCaptcha('wHaMzIlY', salt1, salt2, salt3), 'minestuck:zillyhoo_hammer'],
    [randomizeCaptcha('sLcEzIlY', salt1, salt2, salt3), 'minestuck:cutlass_of_zillywair'],
    [randomizeCaptcha('mAgCzIlY', salt1, salt2, salt3), 'minestuck:thistle_of_zillywich'],
    [randomizeCaptcha('PeEwzIlY', salt1, salt2, salt3), 'alchemyexpanded:flintlock_of_zillyhau'],
    [randomizeCaptcha('BoOmzIlY', salt1, salt2, salt3), 'alchemyexpanded:blunderbuss_of_zillywigh'],
    [randomizeCaptcha('stonSord', salt1, salt2, salt3), 'minecraft:stone_sword'],
    [randomizeCaptcha('ironSord', salt1, salt2, salt3), 'minecraft:iron_sword'],
    [randomizeCaptcha('dimdSord', salt1, salt2, salt3), 'minecraft:diamond_sword'],
    [randomizeCaptcha('ntrtSord', salt1, salt2, salt3), 'minecraft:netherite_sword'],
    [randomizeCaptcha('ZoMoRrOd', salt1, salt2, salt3), 'minestuck:subtractshumidire_zomorrodnegative']
  ];

  let entriesIn = lootEntries(captchas, salt1, salt2);

  newData(event, `loot_table/chests/captcha_codes`, {
    "type": "minecraft:empty",
    "pools": [
      {
        "bonus_rolls": 0.0,
        "entries": entriesIn,
        "name": "computer",
        "rolls": 1.0
      }
    ],
    "random_sequence": "custom:chests/captcha_codes"
  });

  newData(event, `minestuck/captcha_codes`, createExtendablePair(captchas));

  console.log('Ending gen in captchas.');
};

//global.salt = '197371'; //example of global declaration that would go in startup script. Dont do that for this because then client would see it